/*:ja
 * @plugindesc ピクチャアニメーションプラグイン
 * @author TRS
 *
 * @param 先行ピクチャ開始番号
 * @desc 先行読み込み用ピクチャ開始番号
 * @type number
 * @max 100
 * @min 10
 * @default 10
 *
 * @param フェードピクチャ開始番号
 * @desc フェード切り替え時に上乗せ半透明にするピクチャ番号
 * @type number
 * @max 100
 * @min 40
 * @default 40
 *
 * @help
 * プラグインコマンド:
 *   個別座標設定 番号:(ピクチャ番号) 横座標:(横位置) 縦座標:(縦位置)
 *   アニメーション 番号:(ピクチャ番号) ファイル名:(ピクチャファイル名) ウェイト:(フレーム) 最大枚数:(最大枚数) フェード:(あり/なし)
 *   （※フェード未設定時はなしとして認識）
 *   先行ロード ファイル名:(ピクチャファイル名) 最大枚数:(最大枚数)
 *   アニメーション消去 番号:(ピクチャ番号) 
 *   アニメーション全消去
 *   アニメーション反転 番号:(ピクチャ番号) 反転:(する/しない)
 *
 *  ※アニメーションさせる画像は　'ファイル名' + _01～_99で命名してください
 *  ※ループごとの切り替えは　アニメ枚数×ウェイトフレーム数×繰り返し回数　でフレーム数を求めてください
 *  ※並列で動かすとき、ツクール内部で1fのウェイトが発生します。
 *  ※アニメーションピクチャを移動させるとき、エディタのピクチャの移動で移動させてください
 *  ※反転すると原点が右上になりますので個別座標設定で再調整してください
*/

(function() 
{
 	var parameters = PluginManager.parameters('PictureAnimetion');
	
	var priLoadPicNo = Number(parameters['先行ピクチャ開始番号'] || 10);
	var FedePicNo = Number(parameters['フェードピクチャ開始番号'] || 40);
	
	var intXpos = [0,0,0,0,0,0,0,0,0,0];
	var intYpos = [0,0,0,0,0,0,0,0,0,0];
	var intWidth = [100,100,100,100,100,100,100,100,100,100] 
	
	var ArryAnimeCnt = [1,1,1,1,1,1,1,1,1];		//アニメカウント配列用
	var oldFileNames = ["","","","","","","","","",""];
	var lstKeepCommnFileNames = ["","","","","","","","","",""];
	var lstKeepOldFullFileNames = ["","","","","","","","","",""];				//加工した再生ファイル名の保持
	
	var lstAlfaFedeCnt = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0];						//アルファフェード用カウント
	var lstUnVisibles = [255, 255, 255, 255, 255, 255, 255, 255, 255, 255];		//リスト不透明度
	
	
	
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args)
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
		if(command === "アニメーション")
		{
			var intPictureNo = Number( args[0].replace( '番号:', '') );						//ピクチャ番号設定
			var strPictureName = args[1].replace( 'ファイル名:', '') ;						//ピクチャファイル名
			var intPictureWait = Number( args[2].replace( 'ウェイト:', '') );				//ウェイト（F）
			var intMax = Number(args[3].replace( '最大枚数:', '' ) );						//ピクチャ枚数
			
			var IndexNo = intPictureNo - 1;													//インデックス番号算出
			
			//前回と基本ファイル名が違うとき
			if( oldFileNames[IndexNo] != strPictureName )
			{
				ArryAnimeCnt[IndexNo] = 1;											//カウンタークリア
				oldFileNames[IndexNo] = strPictureName;								//今回の基本ファイル名を入れる
			}
			
			//前回と同名の判断
			else if(oldFileNames[IndexNo] === strPictureName)
			{
				//フェードカウント動いてなとき
				if( lstAlfaFedeCnt[ IndexNo ] === 0 )
				{
					lstKeepOldFullFileNames[IndexNo] = strPictureName + '_' + ( '00' + ArryAnimeCnt[IndexNo] ).slice(-2);	//ファイル名キープ
				}
			}
			
			//表示ファイル名設定
			var wrkAnimeCnt = ArryAnimeCnt[IndexNo];
			var strPictureRenban = '_' + ('00' + wrkAnimeCnt).slice(-2);	//0埋め
			
			$gameScreen.showPicture(intPictureNo, strPictureName + strPictureRenban, 0, intXpos[IndexNo], intYpos[IndexNo], intWidth[IndexNo], 100, 255, 0);
			
			if(wrkAnimeCnt < intMax)
				wrkAnimeCnt++;
			else
				wrkAnimeCnt = 1;
			
			ArryAnimeCnt[IndexNo] = wrkAnimeCnt;											//数値返す
			this.wait(intPictureWait);
		}
		else if( command === "フェード切り替え")
		{
			var intPictureNo = Number( args[0].replace( '番号:', '') );						//ピクチャ番号設定
			var IndexNo = intPictureNo - 1;													//インデックス番号算出
			
			//フェード用にキープしている基本ファイル名と旧ファイル名が違う
			if( lstKeepCommnFileNames[IndexNo] != oldFileNames[IndexNo])
			{
				
				 //透明度が0より大きい
				if( lstUnVisibles[ IndexNo ] > 0)
				{
					
					lstAlfaFedeCnt[ IndexNo ] += 1;
					//割り切れた
					if(lstAlfaFedeCnt[ IndexNo ] % 3 === 0)
					{
						lstUnVisibles[ IndexNo ] -= 64;			//不透明度を32下げる
					}
					
					//表示し続けながら消していく
					$gameScreen.showPicture(intPictureNo + FedePicNo, lstKeepOldFullFileNames[IndexNo], 0, intXpos[IndexNo], intYpos[IndexNo], intWidth[IndexNo], 100, lstUnVisibles[ IndexNo ], 0);
					
				}
				
				//透明度が０になった
				else
				{
					//上になってるピクチャ消す
					$gameScreen.erasePicture(intPictureNo + FedePicNo);
					
					lstKeepCommnFileNames[ IndexNo ] = oldFileNames[IndexNo];		//判断用ファイル名入れる
					lstAlfaFedeCnt[ IndexNo ] = 0;									//フェードアウトカウントクリア
					lstUnVisibles[ IndexNo ] = 255;									//不透明度通常値に戻す
				}
			}
			
		}
		
		else if(command === "個別座標設定")
		{
			var intPictureNo = Number(args[0].replace( '番号:','' ) );
			var wrkPicNo = intPictureNo - 1;
			intXpos[wrkPicNo] = Number( args[1].replace( '横座標:','' ) );
			intYpos[wrkPicNo] = Number( args[2].replace( '縦座標:','' ) );
			
			$gameScreen.movePicture(intPictureNo, 0, intXpos[wrkPicNo], intYpos[wrkPicNo], intWidth[wrkPicNo], 100, 255, 0, 1);
		}
		
		else if(command === "先行ロード")
		{
			var strPictureName = ( args[0].replace('ファイル名:','') );							//ピクチャファイル名
			var intMax = Number( args[1].replace('最大枚数:', '') );							//ピクチャ枚数
			var strPictureRenban = "";
			
			//ある分だけピクチャ番号に割り当てる
			for(var i = 1; i <= intMax; i++)
			{
				strPictureRenban = '_' + ('00' + i).slice(-2);	//0埋め
				$gameScreen.showPicture(priLoadPicNo + i, strPictureName + strPictureRenban, 0, 0, 0, 100, 100, 0, 0);
			}
			
			this.wait(4);
		}
		
		else if(command === "アニメーション消去")
		{
			var wrkPicNo = Number( args[0].replace( '番号:','' ) );
			$gameScreen.erasePicture(wrkPicNo);
			ArryAnimeCnt[wrkPicNo - 1] = 1;
		}
		
		else if( command === "アニメーション全消去")
		{
			for(var i = 0; i < ArryAnimeCnt.length; i++)
			{
				ArryAnimeCnt[i] = 1;
				$gameScreen.erasePicture(i + 1);
			}
		}
		
		else if( command === "アニメーション反転" )
		{
			var intPictureNo = Number(args[0].replace( '番号:','' ) );
			var wrkPicNo = intPictureNo - 1;
			var strHan = args[1].replace( '反転:','' );
			
			if( strHan === 'する')
			{
				
				intWidth[wrkPicNo] = -intWidth[wrkPicNo];
			}
			else
			{
				
				intWidth[wrkPicNo] = Math.abs( intWidth[wrkPicNo] );
			}
			
		}
		
	}
	
	/**
	 *　フェード指示されてる時の追加処理
	 */
	function FedeAddAnime( index, intPictureNo, pictureFileName )
	{
		var FedeFileUp = "";						//上地に置くファイル名
		var FedeFileDown = ""						//下地に置くファイル名
		
		//アルファー値が０より大きい時
		if( lstAlfa[index] > 0 )
		{
			
			lstFedeChangeCnt[index] += 1;
			//割り切れた
			if(lstFedeChangeCnt[index] % 4 === 0)
			{
				lstAlfa[index] -= 32;
				
			}
		}
		
		//最後までやった
		else
		{
			lstFedeChangeCnt[index] = 0;
			lstAlfa[index] = 255;
		}
		
		//上にかぶせる新ピクチャ
		$gameScreen.showPicture( intPictureNo + FedePicNo, pictureFileName, 0, intXpos[index], intYpos[index], intWidth[index], 100, lstAlfa[index], 0 );
		$gameScreen.showPicture( intPictureNo, pictureFileName, 0, intXpos[index], intYpos[index], intWidth[index], 100, 255, 0 );
		
	}

})();
